

(defmeth vista-scatterplot-proto :isnew (&rest args)
"Args:  &optional data 
        &key variable-labels point-labels connect-points (connect t)
             (container nil) (show t) (top-most t) (pop-out nil)
             (location '(50 50)) (size '(300 300)) 
             (new-x t) (new-y t) (lines t)
             (menu t) (title \"Scatter Plot\") 
             (legend1 (send $ :name)) (legend2 nil)
             (go-away t) (content-only nil))
connect-points makes the plot a line-plot 
connect adds a connect button
lines controls appearance of the lines button
"
  (cond
    ((and args (integerp (first args)))
     (let* ((keyword-args (rest args))
            (ndim (first args))
            (menu-loc)
            (num)
            (selection)
            )
       (when keyword-args
             (setf menu-loc (position ':MENU keyword-args))
             (when menu-loc 
                   (setf num (length keyword-args))
                   (setf selection (remove (1+ menu-loc) (remove menu-loc (iseq num))))
                   (setf keyword-args (select keyword-args selection))))
       (apply #'call-next-method (append (list ndim) keyword-args))
       (send self :the-real-look-and-feel keyword-args))
       )
     
#| fwy replaced following with above 2/18/2003
     (apply #'call-next-method args)
     (send self :use-color t)
     (send self :plot-buttons :new-x nil :new-y nil :free nil)
     (send self :mouse-mode 'brushing)
     (send self :x-axis t t 5)
     (send self :y-axis t t 5)
     (send self :showing-labels t)
     (send self :legend1 (send current-object :name))
     (send self :legend2 (send self :title))
|#
     )
    (args
     (let* ((keyword-args (rest args))
            (menu-loc)
            (num)
            (selection)
            )
       (when keyword-args
             (setf menu-loc (position ':MENU keyword-args))
             (when menu-loc 
                   (setf num (length keyword-args))
                   (setf selection (remove (1+ menu-loc) (remove menu-loc (iseq num))))
                   (setf keyword-args (select keyword-args selection))))
       (apply #'call-next-method (append (list (length (first args))) keyword-args))
       (apply #'send self :revised-vista-look-and-feel args))
     )
    (t
     (call-next-method 0)
     (apply #'send self :revised-vista-look-and-feel args)
     ))
  self)

(defmeth vista-scatterplot-proto :revised-vista-look-and-feel 
  (&optional data 
        &key variable-labels point-labels connect-points (connect t)
             (container nil) (show t) (top-most t) (pop-out nil)
             (location '(50 50)) (size '(300 300)) (new-x t) (new-y t) (lines t)
             (menu t) (title "Scatter Plot") 
             (legend1 (send $ :name)) (legend2 nil)
             (go-away t) (content-only nil))
  (send self :data data)
  (send self :add-points data)
  (when connect-points (send self :add-lines data :color 'blue))
  (send self :the-real-look-and-feel
        :variable-labels variable-labels :point-labels point-labels
        :connect-points connect-points :connect connect
        :container container :show show :top-most top-most :pop-out pop-out
        :location location :size size :new-x new-x :new-y new-y :lines lines
        :menu menu :title :legend1 legend1 :legend2 legend2
        :go-away go-away :content-only content-only)
  (send self :adjust-to-data)
  (when show (send self :show-window))
  self)